<?php
/**
 * 2007-2025 Your Company
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 *
 * @author    Net-assembly
 * @copyright 2007-2026 Net-assembly
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
class ConfigHistory extends ObjectModel
{
    public $id_ns_caisse_orders;
    public $id_order;
    public $id_shop;
    public $url_value;
    public $response;
    public $server_message;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = [
        'table' => 'ns_caisse_orders',
        'primary' => 'id_ns_caisse_orders',
        'multilang' => false,
        'fields' => [
            'id_order' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
            'id_shop' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
            'url_value' => ['type' => self::TYPE_HTML, 'validate' => 'isString'],
            'response' => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true],
            'server_message' => ['type' => self::TYPE_HTML, 'validate' => 'isString'],
        ],
    ];

    /**
     * @param int $id_order
     *
     * @return ConfigHistory
     */
    public static function loadByIdOrder($id_order)
    {
        $result = Db::getInstance()->getRow('
            SELECT *
            FROM `' . _DB_PREFIX_ . 'ns_caisse_orders` sample
            WHERE sample.`id_order` = ' . (int) $id_order
        );

        return new ConfigHistory($result['id_ns_caisse_orders']);
    }

    public static function getHistories($id_shop)
    {
        $id_shop = ($id_shop !== false) ? $id_shop : Context::getContext()->shop->id;

        $sql = 'SELECT *
            FROM `' . _DB_PREFIX_ . 'ns_caisse_orders` sample
            WHERE sample.`id_shop` = ' . (int) $id_shop . '
            ';

        return Db::getInstance()->executeS($sql);
    }

    public static function isOrderExist($id_order)
    {
        $message = false;

        $result = Db::getInstance()->getRow('
            SELECT *
            FROM `' . _DB_PREFIX_ . 'ns_caisse_orders` sample
            WHERE sample.`id_order` = ' . (int) $id_order
        );

        $id_ns_caisse_orders = $result['id_ns_caisse_orders'];

        if ($id_ns_caisse_orders > 0) {
            $message = true;
        }

        return $message;
    }

    public static function getFormatedAddress(Address $address, $line_sep, $fields_style = [])
    {
        return AddressFormat::generateAddress($address, ['avoid' => []], $line_sep, ' ', $fields_style);
    }
}
